#! /bin/bash

# This file can is double-clickable on Mac-OSX, and launches cytosim-play
#
# Usage: place this file into a folder, which should contain:
#       - a cytosim display executable called 'play' or 'cytosim'
#       - a folder 'run????', where '????' is a 4-digit number
#
# Rename the file as 'play????', matching the 'run????' folder.
#
# Example: a file 'play0001' will launch play in 'run0001', etc.
# The name 'play0001*' will also work (eg. 'play0001-nicest')
#
# F. Nedelec, March. 2010


echo "- - - - - - - - - - - - - - - - - - - - - - - - - -"
echo

############# go to directory containing the script

cd ${0%/*}

############# get a number from the name of the file:

cmd=${0##*/}
nb=${cmd:4:4}

############# find executable:

exe=./bin/play;

if [[ ! -x $exe ]]; then
    echo Error: missing executable
    exit 1;
fi

############# find setup

setup="";
if [[ -a setup.cym ]]; then
    setup="setup=$PWD/setup.cym";
fi

############# go to corresponding 'run' directory:

cd "run$nb" || exit;
echo "Now in directory" $PWD

############# run cytosim

../$exe $setup;

############# clean-up:


if [ $? == 0 ]; then
    printf "\nThank you for using Cytosim!\n\n";
else
    printf "\nCytosim did not terminate normally:\n";
    printf "  Please report this problem to feedback@cytosim.org,\n"
    printf "  and attach the configuration file to the mail\n\n";
fi
